/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;

public class PortPollAction2
implements StatusMapper,
TableStatusNamer {
    private static String bundleName = "ibm.nways.lspeed.LsGeneralResources";
    private boolean loggingOn;

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        I18NString i18NString = new I18NString(bundleName, "AdminPortTable");
        return i18NString;
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bundleName, "AdminPort", objectArray);
        return i18NMsgFormat;
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
        int n = statusModelInfo.get("PortInfo.BridgeMode") instanceof Integer ? (Integer)statusModelInfo.get("PortInfo.BridgeMode") : 0;
        if (statusModelInfo == null || !(statusModelInfo.get("PortInfo.AdminStatus") instanceof Integer) || !(statusModelInfo.get("PortInfo.VBridge") instanceof Integer)) {
            statusAndExplain.statType = StatusType.UNKNOWN;
            statusAndExplain.explain = new I18NString(bundleName, "MissingPortData");
        } else {
            int n2 = (Integer)statusModelInfo.get("PortInfo.AdminStatus");
            int n3 = (Integer)statusModelInfo.get("PortInfo.VBridge");
            Object[] objectArray = statusModelInfo.getIndexes();
            statusAndExplain = this.evaluatePortStatus(n2, n3, n, objectArray);
        }
        statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
    }

    private StatusAndExplain evaluatePortStatus(int n, int n2, int n3, Object[] objectArray) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        switch (n) {
            case 2: {
                statusAndExplain.statType = StatusType.ADMIN_DISABLED;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "AdminPortStatusDisabled", objectArray);
                break;
            }
            case 1: {
                if (n3 == 2) {
                    statusAndExplain.statType = StatusType.ADMIN_DISABLED;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "AdminPortBridgeModeDisabled", objectArray);
                    break;
                }
                if (n2 >= 240) {
                    statusAndExplain.statType = StatusType.ADMIN_DISABLED;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "AdminPortNoBridge", objectArray);
                    break;
                }
                statusAndExplain.statType = StatusType.NORMAL;
                if (n3 == 0) {
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "AdminPortStatusEnabledNoStp", objectArray);
                    break;
                }
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "AdminPortStatusEnabled", objectArray);
                break;
            }
            default: {
                statusAndExplain.statType = StatusType.UNKNOWN;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "AdminPortStatusUnknown", objectArray);
            }
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NString explain;

        StatusAndExplain() {
            PortPollAction2.this = PortPollAction2.this;
        }
    }
}

